<?php $__env->startSection('Title'); ?>پنل مدیریت | رویدادها - <?php echo e($event_info->name); ?><?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>رویدادها - <?php echo e($event_info->name); ?></h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">رویدادها - <?php echo e($event_info->name); ?></li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="<?php echo e(route('admin.event_provinces.create', ['event_id' => $event_info->id])); ?>" class="btn btn-sm btn-success">
                        <i class="fa fa-plus mr-2"></i>
                        افزودن رویداد استانی جدید
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <?php if(!empty($events->all())): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8 text-center">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>استان</th>
                                <th>فیلم توضیحات رویداد</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php
                                $row = (($events->currentPage() - 1) * $events->perPage() ) + 1;
                            ?>
                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="w60">
                                        <span><?php echo e($row); ?></span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            <?php echo e($event->province->name); ?>

                                        </p>
                                    </td>

                                    <td>
                                        <a class="btn btn-light btn-sm" target="_blank" href="<?php echo e($event['event_description_video']); ?>">
                                            <i class="fa fa-eye mr-2"></i>
                                            مشاهده
                                        </a>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('admin.event_atoms.index', ['event_province_id' => $event['id']])); ?>">
                                            <button class="btn btn-dark" data-toggle="tooltip" title="اتم های رویداد">
                                                <i class="fa fa-user-o"></i>
                                            </button>
                                        </a>

                                        <a href="<?php echo e(route('admin.event_videos.index', ['event_province_id' => $event['id']])); ?>">
                                            <button class="btn btn-warning" data-toggle="tooltip" title="فیلم های رویداد">
                                                <i class="fa fa-video-camera"></i>
                                            </button>
                                        </a>

                                        <a href="<?php echo e(route('admin.event_pictures.index', ['event_province_id' => $event['id']])); ?>">
                                            <button class="btn btn-info" data-toggle="tooltip" title="تصاویر رویداد">
                                                <i class="fa fa-camera"></i>
                                            </button>
                                        </a>

                                        <a href="<?php echo e(route('admin.event_provinces.edit', ['event_province' => $event['id']])); ?>">
                                            <button class="btn btn-primary" data-toggle="tooltip" title="ویرایش رویداد">
                                                <i class="icon-pencil"></i>
                                            </button>
                                        </a>




                                    </td>
                                </tr>
                                <?php
                                    $row++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <?php echo e($events->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/events/provinces/index.blade.php ENDPATH**/ ?>