<?php $__env->startSection('Title'); ?>پنل مدیریت | دسته بندی مقالات<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-js'); ?>
    <script>
        function removeCategory(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/post_category/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>دسته بندی مقالات</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">دسته بندی مقالات</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="<?php echo e(route('admin.post_category.create')); ?>" class="btn btn-sm btn-success">
                        <i class="fa fa-plus mr-2"></i>
                        افزودن دسته بندی جدید مقالات
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <?php if(!empty($categories->all())): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>عنوان دسته بندی</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php
                                $row = (($categories->currentPage() - 1) * $categories->perPage() ) + 1;
                            ?>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="w60">
                                        <span><?php echo e($row); ?></span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            <?php echo e($category['cat_title']); ?>

                                        </p>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('admin.post_category.show', ['post_category' => $category['id']])); ?>">
                                            <button class="btn btn-primary">
                                                <i class="icon-pencil"></i>
                                            </button>
                                        </a>

                                        <button onclick="removeCategory(<?php echo e($category['id']); ?>)" class="btn btn-danger">
                                            <i class="icon-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <?php
                                    $row++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <?php echo e($categories->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- The Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف دسته بندی</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از خذف دسته بندی اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\base_project\resources\views/admin/post/category/index.blade.php ENDPATH**/ ?>