<?php $__env->startSection('Title'); ?>پنل مدیریت | کاربران<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>کاربران</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('admin.dashboard')); ?>">
                                    پنل مدیریت
                                </a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">کاربران</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="card">
                    <form method="post" action="<?php echo e(route('admin.users.search')); ?>" class="card-body">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-12 col-sm-6 col-md-3 mb-4">
                                <label>نام</label>
                                <input type="text" name="first_name" class="form-control">
                            </div>

                            <div class="col-12 col-sm-6 col-md-3 mb-4">
                                <label>نام خانوادگی</label>
                                <input type="text" name="last_name" class="form-control">
                            </div>

                            <div class="col-12 col-sm-6  <?php if(!$searched): ?> col-md-3 <?php else: ?> col-md-2 <?php endif; ?> mb-4">
                                <label>جنسیت</label>
                                <select name="gender" class="form-control">
                                    <option value="">همه</option>
                                    <option value="1">مرد</option>
                                    <option value="2">زن</option>
                                </select>
                            </div>

                            <?php if(!$searched): ?>
                                <div class="col-12 col-sm-6 col-md-3 mb-4">
                                    <button type="submit" class="btn btn-success w-100 mt-29">
                                        <i class="fa fa-search mr-2"></i>
                                        فیلتر کنید
                                    </button>
                                </div>
                            <?php else: ?>
                                <div class="col-12 col-md-2 mb-4">
                                    <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-danger w-100 mt-29">
                                        <i class="fa fa-times-circle mr-2"></i>
                                        حذف فیلتر
                                    </a>
                                </div>

                                <div class="col-12 col-sm-6 col-md-2 mb-4">
                                    <button type="submit" class="btn btn-success w-100 mt-29">
                                        <i class="fa fa-search mr-2"></i>
                                        فیلتر کنید
                                    </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    </form>
                </div>

                <div class="card">
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>نام و نام خانوادگی</th>
                                <th>جنسیت</th>
                                <th>وضعیت</th>
                                <th>نقش</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php if(!$searched and $users->lastPage() > 1): ?>
                                <?php
                                    $row = (($users->currentPage() - 1) * $users->perPage() ) + 1;
                                ?>
                            <?php else: ?>
                                <?php
                                    $row = 1;
                                ?>
                            <?php endif; ?>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="w60">
                                        <span><?php echo e($row); ?></span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            <?php echo e($user['first_name'] . ' ' . $user['last_name']); ?>

                                        </p>
                                    </td>

                                    <td>
                                        <?php if($user['gender'] != null): ?>
                                            <span class="badge <?php echo e($user['gender_class']); ?>">
                                                   <?php echo e($user['gender_name']); ?>

                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-default">
                                                    تعیین نشده
                                            </span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if($user['is_active'] == 1): ?>
                                            <span class="badge badge-success">
                                                    فعال
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">
                                                    غیر فعال
                                            </span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <span class="badge <?php echo e($role['role_class']); ?> mr-2">
                                                <?php echo e($role->role_name); ?>

                                            </span>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>

                                    <td>
                                        <?php if($user['id'] == auth()->id()): ?>
                                            <a href="<?php echo e(route('admin.profile')); ?>">
                                                <button class="btn btn-primary">
                                                    <i class="icon-pencil"></i>
                                                </button>
                                            </a>
                                        <?php else: ?>
                                            <a href="<?php echo e(route('admin.users.edit', ['user_id' => $user['user_id']])); ?>">
                                                <button class="btn btn-primary">
                                                    <i class="icon-pencil"></i>
                                                </button>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php
                                    $row++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <?php if(!$searched and $users->lastPage() > 1): ?>
                        <div class="bg-white p-2 mt--15px">
                            <?php echo e($users->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\base_project\resources\views/admin/users/index.blade.php ENDPATH**/ ?>