<?php $__env->startSection('Title'); ?>
    پنل مدیریت | فرم ساز
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-js'); ?>
    <script>
        function removeForm(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/formBuilder/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>فرم ساز</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">فرم ساز</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="<?php echo e(route('admin.formBuilder.create')); ?>" class="btn btn-sm btn-success">
                        <i class="fa fa-plus mr-2"></i>
                        افزودن فرم جدید
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <?php if(!empty($forms->all())): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8 text-center">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>نام فرم</th>
                                <th>فعال / غیر فعال</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php
                                $row = 1;
                            ?>
                            <?php $__currentLoopData = $forms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="w60">
                                        <span><?php echo e($row); ?></span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            <?php echo e($form['name']); ?>

                                        </p>
                                    </td>

                                    <td>
                                        <?php if($form['is_active'] == 1): ?>
                                            <span class="badge badge-success">
                                                فعال
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">
                                                غیر فعال
                                            </span>

                                            <form class="d-inline-block"
                                                  action="<?php echo e(route('admin.active_form', ['id' => $form['id']])); ?>"
                                                  method="post">
                                                <?php echo csrf_field(); ?>
                                                <button class="btn btn-success btn-sm">
                                                    فعال شود
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        ------
                                        
                                        
                                        
                                    </td>
                                </tr>
                                <?php
                                    $row++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- The Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف فرم</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف فرم اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/forms_builder/index.blade.php ENDPATH**/ ?>