<?php $__env->startSection('Title'); ?>
    پنل مدیریت | فرم ساز
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-css'); ?>
    <style>
        .btn.btn-success:disabled {
            opacity: .5 !important;
        }

        .my_toast_txt {
            margin: 19px 0 0 0;
            float: right;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-js'); ?>
    <script src="<?php echo e(asset('vendor/sweetalert/sweetalert.all.js')); ?>"></script>
    <script>
        let form_name_inp = $("#form_name_inp");

        function addForm(tag) {
            $(tag).prop('disabled', true);
            $(tag).text('لطفا منتظر بمانید ...');

            if (!form_name_inp.val()) {
                show_sweetalert_msg('نام فرم الزامی است', 'error');
                activeSubmitButton(tag);
                return false;
            }

            let active_fields = $('.my_checkbox_field:checked');
            if (active_fields.length < 1) {
                show_sweetalert_msg('حداقل یک فیلد را انتخاب کنید', 'error');
                activeSubmitButton(tag);
                return false;
            }

            let fields = [];
            for (let i = 0; i < active_fields.length; i++) {
                fields.push(active_fields.eq(i).attr('data-id'));
            }

            let data = {
                _token: '<?php echo e(csrf_token()); ?>',
                fields: fields,
                form_name: form_name_inp.val()
            }

            $.ajax({
                url: '<?php echo e(route("admin.formBuilder.store")); ?>',
                type: 'POST',
                contentType: 'application/json',
                data: JSON.stringify(data),
                success: function (response) {
                    console.log(response);

                    if (response.error) {
                        show_sweetalert_msg(response.message, 'error');
                        setTimeout(() => {
                            // location.reload();
                        }, 2000);
                    } else {
                        show_sweetalert_msg(response.message, 'success');
                        setTimeout(() => {
                            location.href = "<?php echo e(route('admin.formBuilder.index')); ?>";
                        }, 1900)
                    }
                },
                error: function (xhr, status, error) {
                    show_sweetalert_msg('خطای سمت سرور رخ داده است، لطفا اندکی بعد تلاش کنید', 'error');
                    activeSubmitButton(tag);
                    return false;
                }
            });
        }

        function activeSubmitButton(tag) {
            $(tag).prop('disabled', false);
            $(tag).html('<i class="fa fa-plus mr-2"></i> افزودن فرم');
        }

        function show_sweetalert_msg(msg, icon) {
            new swal({
                html: "<p class='my_toast_txt'>" + msg + "</p>",
                toast: true,
                icon: icon,
                showConfirmButton: false,
                position: 'top',
                timerProgressBar: true,
                timer: 3500
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>ساخت فرم جدید</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">ساخت فرم جدید</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-lg-3 col-md-6">
                <div class="card">
                    <div class="body">
                        <div class="row">
                            <div class="col-12 mb-4">
                                <label>نام فرم</label>
                                <input id="form_name_inp" type="text" name="form_name" class="form-control">
                            </div>

                            <?php $__currentLoopData = $fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-12 mb-4">
                                    <label>
                                        <input data-id="<?php echo e($field['id']); ?>" required type="checkbox"
                                               name="<?php echo e($field['field_name']); ?>" class="my_checkbox_field float-left">
                                        <span class="float-left ml-2">
                                            <?php echo e($field['field_label']); ?>

                                        </span>
                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div class="col-12 mb-4">
                                <button onclick="addForm(this)" class="btn btn-success w-100">
                                    <i class="fa fa-plus mr-2"></i>
                                    افزودن فرم
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/forms_builder/create.blade.php ENDPATH**/ ?>