<?php $__env->startSection('Title'); ?>
    پنل مدیریت | اتم های برتر
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>اتم های برتر</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">اتم های برتر</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <?php if(!empty($events->all())): ?>
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8 text-center">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>نام</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            <?php
                                $row = (($events->currentPage() - 1) * $events->perPage() ) + 1;
                            ?>
                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="w60">
                                        <span><?php echo e($row); ?></span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            <?php echo e($event->name); ?>

                                        </p>
                                    </td>

                                    <td>
                                        <?php if($event->is_active > 0): ?>
                                            <span class="badge badge-success">
                                                فعال
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-danger">
                                                غیر فعال
                                            </span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('admin.bestAtoms.index', ['event_id' => $event['id']])); ?>">
                                            <button class="btn btn-warning" data-toggle="tooltip" title="اتم های برتر">
                                                <i class="icon-users"></i>
                                            </button>
                                        </a>

                                        
                                        
                                        
                                    </td>
                                </tr>
                                <?php
                                    $row++;
                                ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>

                        <?php echo e($events->links()); ?>

                    </div>
                <?php else: ?>
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/bestAtoms/main.blade.php ENDPATH**/ ?>