<?php $__env->startSection('Title'); ?>
    پنل مدیریت | صفحه اتم های برتر
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/vendor/summernote/dist/summernote.css')); ?>"/>

    <style>
        input::placeholder {
            color: #d5d5d5 !important;
        }

        .w-150px {
            width: 150px;
        }

        .selection_description {
            max-width: 95%;
            white-space: normal;
            line-height: 28px;
            font-size: 8pt;
            color: #808080;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-js'); ?>
    <script src="<?php echo e(asset('admin/assets/vendor/summernote/dist/summernote.js')); ?>"></script>
    <script>
        $(".dropify").dropify();

        function deleteAtomOfBestPage(id) {
            var RemoveAtomModal = $("#RemoveAtomModal");
            RemoveAtomModal.find('#atom_id_delete').val(id);
            RemoveAtomModal.modal('show');
        }

        function deleteSponsorOfBestPage(id) {
            var RemoveAtomModal = $("#RemoveSponsorModal");
            RemoveAtomModal.find('#sponsor_id_delete').val(id);
            RemoveAtomModal.modal('show');
        }
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>صفحه اتم های برتر - (<?php echo e($event_info->name); ?>)</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">صفحه اتم های برتر - (<?php echo e($event_info->name); ?>)</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="row">
                    <div class="col-12 mb-2 mt-4">
                        <h5>اطلاعات کلی - (<?php echo e($event_info->name); ?>)</h5>
                    </div>
                </div>
                <div class="card">
                    <form action="<?php echo e(route('admin.bestAtoms.update', ['event_id' => $event_id ,'id' => $best_atom_info['id'] ?? 0])); ?>"
                          class="body" method="post"
                          enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-12 col-xl-6">
                                <div class="row">
                                    <div class="col-12 col-lg-6 col-xl-6 mb-4">
                                        <label>تصویر هدر</label>
                                        <input data-default-file="<?php echo e(asset($best_atom_info['top_img'] ?? '')); ?>"
                                               type="file"
                                               name="top_img" class="dropify">
                                    </div>
                                    <div class="col-12 col-lg-6 col-xl-6 mb-4">
                                        <label>تصویر منتخب ها</label>
                                        <input data-default-file="<?php echo e(asset($best_atom_info['the_selected_img'] ?? '')); ?>"
                                               type="file" name="the_selected_img" class="dropify">
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-xl-6">
                                <div class="row">
                                    <div class="col-12 col-lg-6 col-xl-6 mb-4">
                                        <label>عنوان کلی</label>
                                        <input required name="main_title" type="text" class="form-control"
                                               value="<?php echo e($best_atom_info['main_title'] ?? ''); ?>">
                                    </div>
                                    <div class="col-12 col-lg-6 col-xl-6 mb-4">
                                        <label>عنوان برای اهداف</label>
                                        <input required name="target_title" type="text" class="form-control"
                                               value="<?php echo e($best_atom_info['target_title'] ?? ''); ?>">
                                    </div>
                                    <div class="col-12 mb-4">
                                        <label>توضیحات برای اهداف</label>
                                        <textarea rows="5" required name="target_description" type="text"
                                                  class="form-control"><?php echo e($best_atom_info['target_description'] ?? ''); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12 text-right">
                                <button class="btn btn-sm btn-success">
                                    <i class="fa fa-edit mr-2"></i>
                                    ذخیره تغییرات
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>


        <?php if(!empty($best_atom_info)): ?>
            <div class="row mt-4">
                <div class="col-12">
                    <div class="row">
                        <div class="col-12 mt-4 mb-2">
                            <h5>افزودن منتخب جدید - (<?php echo e($event_info->name); ?>)</h5>
                        </div>
                    </div>
                    <div class="card">
                        <div class="body">
                            <div class="row">
                                <form action="<?php echo e(route('admin.addNewBestAtom', ['event_id' => $event_id])); ?>"
                                      method="post" enctype="multipart/form-data"
                                      class="col-12 mb-4">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-12 col-xl-3 mb-4">
                                            <label>تصویر منتخب</label>
                                            <input type="file" name="img" class="dropify">
                                        </div>
                                        <div class="col-12 col-xl-9">
                                            <div class="row">
                                                <div class="col-12 col-lg-6 col-xl-6 mb-4">
                                                    <label>عنوان</label>
                                                    <input required name="title" type="text" class="form-control"
                                                           value="">
                                                </div>
                                                <div class="col-12 mb-4">
                                                    <label>توضیحات</label>
                                                    <textarea rows="5" required name="description" type="text"
                                                              class="form-control"></textarea>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-12 text-right">
                                            <button class="btn btn-sm btn-success">
                                                <i class="fa fa-plus mr-2"></i>
                                                افزودن منتخب
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive mt-4">
                        <div class="col-12 mt-4">
                            <h5>لیست منتخب ها</h5>
                        </div>
                        <table class="table table-hover table-custom spacing8 text-center">
                            <tbody>
                            <?php $__currentLoopData = $atoms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $atom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <img class="w-150px" src="<?php echo e(asset($atom['img'])); ?>">
                                    </td>
                                    <td>
                                        <?php echo e($atom['title']); ?>

                                    </td>
                                    <td>
                                        <p class="text-justify selection_description">
                                            <?php echo e($atom['description']); ?>

                                        </p>
                                    </td>
                                    <td>
                                        <button onclick="deleteAtomOfBestPage(<?php echo e($atom['id']); ?>)"
                                                class="btn btn-sm btn-danger">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12 col-xl-3">
                    <div class="row">
                        <div class="col-12 mt-4 mb-2">
                            <h5>افزودن حامی جدید - (<?php echo e($event_info->name); ?>)</h5>
                        </div>
                    </div>
                    <div class="card">
                        <div class="body">
                            <div class="row">
                                <form
                                    action="<?php echo e(route('admin.bestAtomAddNewSponsors', ['event_id' => $event_id])); ?>"
                                    method="post" enctype="multipart/form-data"
                                    class="col-12 mb-4">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="row">
                                                <div class="col-12 mb-4">
                                                    <label>تصویر حامی</label>
                                                    <input type="file" name="img" class="dropify">
                                                </div>
                                                <div class="col-12 text-right">
                                                    <button class="btn btn-sm btn-success">
                                                        <i class="fa fa-plus mr-2"></i>
                                                        افزودن حامی
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-12 col-xl-9">
                    <div class="table-responsive mt-4">
                        <div class="col-12">
                            <h5>لیست حامیان ما</h5>
                        </div>
                        <table class="table table-hover table-custom spacing8 text-center">
                            <tbody>
                            <?php $__currentLoopData = $sponsors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $sponsor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <?php echo e($key + 1); ?>

                                    </td>
                                    <td>
                                        <img class="w-150px" src="<?php echo e(asset($sponsor['img'])); ?>">
                                    </td>
                                    <td>
                                        <button onclick="deleteSponsorOfBestPage(<?php echo e($sponsor['id']); ?>)"
                                                class="btn btn-sm btn-danger">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>



    <div class="modal" id="RemoveAtomModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف اتم</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف اتم اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="<?php echo e(route('admin.deleteBestAtom')); ?>" method="post" class="modal-footer">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="atom_id" id="atom_id_delete">
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>
            </div>
        </div>
    </div>

    <div class="modal" id="RemoveSponsorModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف حامی</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف حامی اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="<?php echo e(route('admin.bestAtomDeleteSponsors')); ?>" method="post" class="modal-footer">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="atom_id" id="sponsor_id_delete">
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/bestAtoms/index.blade.php ENDPATH**/ ?>