<?php $__env->startSection('Title'); ?>
    پنل مدیریت | فیلم های رویداد (استان <?php echo e($event_info->province->name); ?> - <?php echo e($event_info->event->name); ?>)
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-css'); ?>
    <style>
        .w-85px {
            width: 85px;
        }
        .w-250px {
            width: 250px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-js'); ?>
    <script>
        function removeVideo(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/event_videos/delete/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }
    </script>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>فیلم های رویداد (استان <?php echo e($event_info->province->name); ?> - <?php echo e($event_info->event->name); ?>)</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">پنل مدیریت</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.events.index')); ?>">رویداد ها</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.event_provinces.index', ['event_id' => $event_info->event_id])); ?>"><?php echo e($event_info->event->name); ?></a></li>
                            <li class="breadcrumb-item active" aria-current="page">فیلم های رویداد
                                (استان <?php echo e($event_info->province->name); ?>)
                            </li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="<?php echo e(route('admin.event_provinces.edit', ['event_province'=> $event_info['id']])); ?>"
                       class="btn btn-sm btn-warning">
                        <i class="fa fa-paperclip mr-2"></i>
                        برو به صفحه این رویداد
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="row">
                    <div class="col-12 col-lg-4 col-xl-3">
                        <div class="card">
                            <form action="<?php echo e(route('admin.event_videos.store', ['event_province_id' => $event_info['id']])); ?>"
                                  method="post" enctype="multipart/form-data" class="card-body">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-12">
                                        <label>ویدئو (لینک)</label>
                                        <input dir="ltr" type="text" class="form-control" name="video">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <label>تصویر پوستر (لینک)</label>
                                        <input dir="ltr" type="text" class="form-control" name="poster">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <button class="btn btn-success btn-sm w-100">
                                            <i class="fa fa-plus mr-2"></i>
                                            افزودن ویدئو جدید
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="col-12 col-lg-8 col-xl-9">
                        <?php if(!empty($videos->all())): ?>
                            <div class="table-responsive">
                                <table class="table table-hover table-custom spacing8 text-center">
                                    <thead>
                                    <tr>
                                        <th><b>#</b></th>
                                        <th><b>ویدئو</b></th>
                                        <th><b>تصویر پوستر</b></th>
                                        <th><b>عملیات</b></th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                    <?php
                                        $row = 1;
                                    ?>
                                    <?php $__currentLoopData = $videos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($row); ?></td>
                                            <td>
                                                <a target="_blank" href="<?php echo e($video['video']); ?>">
                                                    <video controls="controls" src="<?php echo e($video['video']); ?>" class="w-250px"></video>
                                                </a>
                                            </td>
                                            <td>
                                                <a target="_blank" href="<?php echo e($video['poster']); ?>">
                                                    <img src="<?php echo e($video['poster']); ?>" class="w-85px">
                                                </a>
                                            </td>
                                            <td>
                                                <button onclick="removeVideo(<?php echo e($video['id']); ?>)" class="btn btn-danger"
                                                        data-toggle="tooltip" title="حذف ویدئو از رویداد">
                                                    <i class="icon-trash"></i>
                                                </button>
                                            </td>
                                        </tr>

                                        <?php
                                            $row++;
                                        ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                        <?php else: ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-12">
                                                    <p class="alert alert-danger mb-0">
                                                        موردی یافت نشد.
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- The Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف ویدئو از رویداد</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف ویدئو از رویداد اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/events/videos/index.blade.php ENDPATH**/ ?>