<?php $__env->startSection('Title'); ?>پنل مدیریت | ویرایش رویداد<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/vendor/summernote/dist/summernote.css')); ?>"/>
    <link rel="stylesheet" href="<?php echo e(asset('admin/assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css')); ?>"/>

    <style>
        input::placeholder {
            color: #d5d5d5 !important;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('custom-js'); ?>
    <script src="<?php echo e(asset('admin/assets/vendor/summernote/dist/summernote.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js')); ?>"></script>
    <script>
        $(".dropify").dropify();

        $('#province_select').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            maxHeight: 400,
            selectAll: true,
            nonSelectedText: 'استان را انتخاب کنید',
            filterPlaceholder: 'جستجو کنید',
            allSelectedText: 'همه انتخاب شدند',
        });
    </script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>رویدادها</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">پنل مدیریت</a></li>
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.events.index')); ?>">رویداد ها</a></li>
                            <li class="breadcrumb-item active" aria-current="page">ویرایش رویداد</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="<?php echo e(route('admin.event_provinces.index', ['event_id' => $event_info['event_id']])); ?>" class="btn btn-sm btn-danger">
                        <i class="fa fa-arrow-right mr-2"></i>
                        بازگشت به رویدادها
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="card">
                    <form action="<?php echo e(route('admin.event_provinces.update', ['event_province' => $event_info['id']])); ?>" enctype="multipart/form-data" method="post" class="body">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-12 col-lg-5 col-xl-3">
                                <div class="row">
                                    <div class="col-12">
                                        <label>تصویر اصلی</label>
                                        <?php $__errorArgs = ['img'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <input data-default-file="<?php echo e(asset($event_info['event_img'])); ?>" type="file" name="img" class="dropify">
                                    </div>

                                    <div class="col-12 mt-4">
                                        <label>تصویر بالا (عنوان)</label>
                                        <?php $__errorArgs = ['top_img'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <input data-default-file="<?php echo e(asset($event_info['event_top_img'])); ?>" type="file" name="top_img" class="dropify">
                                    </div>

                                    <div class="col-12 mt-4">
                                        <label>استان</label>
                                        <?php $__errorArgs = ['province'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="multiselect_div">
                                            <select required="required" id="province_select"
                                                    class="multiselect multiselect-custom form-control"
                                                    name="province">
                                                <option value="">انتخاب کنید</option>
                                                <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option
                                                        <?php if($event_info['province_id'] == $province['id']): ?> selected="selected" <?php endif; ?>
                                                        value="<?php echo e($province['id']); ?>">
                                                        <?php echo e($province['name']); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 mt-4">
                                        <label>رویداد</label>
                                        <?php $__errorArgs = ['event_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <div class="multiselect_div">
                                            <select required="required" id="event_select"
                                                    class="multiselect multiselect-custom form-control"
                                                    name="event_id">
                                                <option value="">انتخاب کنید</option>
                                                <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option <?php if($event->id == $event_info['event_id']): ?> selected="selected" <?php endif; ?> value="<?php echo e($event['id']); ?>">
                                                        <?php echo e($event['name']); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-lg-7 col-xl-9">
                                <div class="row">
                                    <div class="col-12 col-xl-4 mb-4">
                                        <label>لینک تک فیلم توضیحات (ویدئو)</label>
                                        <?php $__errorArgs = ['description_video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <input value="<?php echo e($event_info['event_description_video']); ?>" required="required" dir="ltr" type="text" name="description_video" class="form-control" placeholder="ex: https://test.com/video.mp4">
                                    </div>
                                    <div class="col-12 col-xl-4 mb-4">
                                        <label>لینک پوستر تک فیلم توضیحات (عکس)</label>
                                        <?php $__errorArgs = ['description_video_poster'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <input value="<?php echo e($event_info['event_description_video_poster']); ?>" required="required" dir="ltr" type="text" name="description_video_poster" class="form-control" placeholder="ex: https://test.com/poster.jpg">
                                    </div>
                                    <div class="col-12 col-xl-4 mb-4">
                                        <label>عنوان توضیحات (کادر سبز)</label>
                                        <?php $__errorArgs = ['description_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <input value="<?php echo e($event_info['event_description_title']); ?>" required="required" type="text" name="description_title" class="form-control">
                                    </div>

                                    <div class="col-12 mb-4">
                                        <label>توضیحات رویداد</label>
                                        <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="validation_label_error"><?php echo e($message); ?></span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        <textarea name="description" class="summernote"><?php echo e($event_info['event_description']); ?></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-12 text-right">
                                <button class="btn btn-success btn-sm px-4">
                                    <i class="fa fa-editcls mr-2"></i>
                                    ویرایش رویداد
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\atom_event\back\resources\views/admin/events/provinces/edit.blade.php ENDPATH**/ ?>