<?php

use App\Http\Controllers\admin\adminBestAtomPage;
use App\Http\Controllers\admin\adminDashboardController;
use App\Http\Controllers\admin\adminEventAtomsController;
use App\Http\Controllers\admin\adminEventController;
use App\Http\Controllers\admin\adminEventProvinceController;
use App\Http\Controllers\admin\adminEventPicturesController;
use App\Http\Controllers\admin\adminEventVideosController;
use App\Http\Controllers\admin\adminFormBuilder;
use App\Http\Controllers\admin\adminHomepageController;
use App\Http\Controllers\admin\adminUserController;
use App\Http\Controllers\admin\captchaController;
use App\Http\Controllers\admin\loginController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/', function () {
    abort(404);
})->name('home');

Route::get('get-captcha/{c}', [captchaController::class, 'index'])->name('get_captcha');

//Admin
Route::namespace('App\Http\Controllers\admin')
    ->middleware('adminAuth')
    ->name('admin.')
    ->prefix('/panel')
    ->group(function () {
        //dashboard
        Route::get('dashboard', [adminDashboardController::class, 'index'])->name('dashboard');
        Route::get('profile', [adminDashboardController::class, 'profile'])->name('profile');
        Route::post('profile/update', [adminDashboardController::class, 'profile_update'])->name('profile_update');
        Route::post('change-pass', [adminDashboardController::class, 'changePass'])->name('changePass');

        //users
        Route::get('users', [adminUserController::class, 'index'])->name('users');
        Route::post('users/search', [adminUserController::class, 'search'])->name('users.search');
        Route::get('users/edit/{user_id}', [adminUserController::class, 'edit'])->name('users.edit');
        Route::post('users/update/{user_id}', [adminUserController::class, 'update'])->name('users.update');
        Route::post('users/delete', [adminUserController::class, 'delete'])->name('users.delete');

//        //post categories
//        Route::resource('post_category', adminPostCategories::class);
//
//        //posts
//        Route::resource('posts', adminPostController::class);

        //events
        Route::resource('events', adminEventController::class);
        //event provinces
        Route::get('event_provinces/{event_id}', [adminEventProvinceController::class, 'index'])->name('event_provinces.index');
        Route::get('event_provinces/{event_id}/create', [adminEventProvinceController::class, 'create'])->name('event_provinces.create');
        Route::get('event_provinces/{event_province}/edit', [adminEventProvinceController::class, 'edit'])->name('event_provinces.edit');
        Route::post('event_provinces/store', [adminEventProvinceController::class, 'store'])->name('event_provinces.store');
        Route::post('event_provinces/{event_province}/update', [adminEventProvinceController::class, 'update'])->name('event_provinces.update');
        //events atoms
        Route::get('event_atoms/{event_province_id}', [adminEventAtomsController::class, 'index'])->name('event_atoms.index');
        Route::post('event_atoms/store/{event_province_id}', [adminEventAtomsController::class, 'store'])->name('event_atoms.store');
        Route::post('event_atoms/delete/{atom_id}', [adminEventAtomsController::class, 'delete'])->name('event_atoms.delete');
        Route::post('event_atoms/update/{atom_id}', [adminEventAtomsController::class, 'update'])->name('event_atoms.update');
        //events pictures
        Route::get('event_pictures/{event_province_id}', [adminEventPicturesController::class, 'index'])->name('event_pictures.index');
        Route::post('event_pictures/store/{event_province_id}', [adminEventPicturesController::class, 'store'])->name('event_pictures.store');
        Route::post('event_pictures/delete/{picture_id}', [adminEventPicturesController::class, 'delete'])->name('event_pictures.delete');
        //events videos
        Route::get('event_videos/{event_province_id}', [adminEventVideosController::class, 'index'])->name('event_videos.index');
        Route::post('event_videos/store/{event_province_id}', [adminEventVideosController::class, 'store'])->name('event_videos.store');
        Route::post('event_videos/delete/{picture_id}', [adminEventVideosController::class, 'delete'])->name('event_videos.delete');

        //homepage
        Route::resource('homepage', adminHomepageController::class);

        //form builder
        Route::resource('formBuilder', adminFormBuilder::class);
        Route::post('formBuilder/active/{id}', [adminFormBuilder::class, 'active_form'])->name('active_form');
        Route::get('sentForms', [adminFormBuilder::class, 'sentForms'])->name('sentForms');

        //best atoms page
//        Route::resource('bestAtoms', adminBestAtomPage::class);
        Route::get('bestAtoms', [adminBestAtomPage::class, 'main'])->name('bestAtoms.main');
        Route::get('bestAtoms/{event_id}', [adminBestAtomPage::class, 'index'])->name('bestAtoms.index');
        Route::get('bestAtoms/{event_id}/create', [adminBestAtomPage::class, 'create'])->name('bestAtoms.create');
        Route::get('bestAtoms/{best_atom}/edit', [adminBestAtomPage::class, 'edit'])->name('bestAtoms.edit');
        Route::post('bestAtoms/store', [adminBestAtomPage::class, 'store'])->name('bestAtoms.store');
        Route::post('bestAtoms/{event_id}/{id}/update', [adminBestAtomPage::class, 'update'])->name('bestAtoms.update');
        //best atoms page atoms
        Route::post('addNewBestAtom/{event_id}', [adminBestAtomPage::class, 'addNewBestAtom'])->name('addNewBestAtom');
        Route::post('deleteBestAtom', [adminBestAtomPage::class, 'deleteBestAtom'])->name('deleteBestAtom');
        //best atoms page sponsors
        Route::post('addNewSponsors/{event_id}', [adminBestAtomPage::class, 'addNewSponsors'])->name('bestAtomAddNewSponsors');
        Route::post('bestAtomDeleteSponsors', [adminBestAtomPage::class, 'bestAtomDeleteSponsors'])->name('bestAtomDeleteSponsors');
    });

//login & logout
Route::middleware('loginMiddleware')
    ->get('/admin-login', [loginController::class, 'index'])
    ->name('login.view');

Route::middleware('loginMiddleware')
    ->post('/login/do', [loginController::class, 'do_login'])
    ->name('login.do');

Route::post('/logout', function () {
    auth()->logout();
    return redirect()->route('login.view');
})->name('logout');
