<?php

use App\Http\Controllers\api\v1\generalController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// v1
Route::group([
    'namespace' => 'App\Http\Controllers\api\v1',
    'prefix' => 'v1/'
], function ($router) {
    Route::post('getEvents', [generalController::class, 'getEvents']);
    Route::post('getEventDetail', [generalController::class, 'getEventDetail']);
    Route::post('getBestAtoms', [generalController::class, 'getBestAtoms']);
    Route::post('getHomepage', [generalController::class, 'getHomepage']);

    //GIS
    Route::post('getIranAtomsCount', [generalController::class, 'getIranAtomsCount']);
    Route::post('getProvinceAtoms', [generalController::class, 'getProvinceAtoms']);

    //form
    Route::post('getActiveForm', [generalController::class, 'getActiveForm']);
    Route::post('submit_event_form', [generalController::class, 'submit_event_form']);
});
