@extends('layouts.admin_layout')

@section('Title')پنل مدیریت | مقالات@endsection

@section('custom-js')
    <script>
        function removePost(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/posts/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }
    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>مقالات</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="#">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">مقالات</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.posts.create')}}" class="btn btn-sm btn-success">
                        <i class="fa fa-plus mr-2"></i>
                        افزودن مقاله جدید
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                @if(!empty($posts->all()))
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>عنوان مقاله</th>
                                <th>نامک مقاله</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php
                                $row = (($posts->currentPage() - 1) * $posts->perPage() ) + 1;
                            @endphp
                            @foreach($posts as $post)
                                <tr>
                                    <td class="w60">
                                        <span>{{$row}}</span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            {{$post['post_title']}}
                                        </p>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            {{$post['post_nickname']}}
                                        </p>
                                    </td>

                                    <td>
                                        <a target="_blank" href="#">
                                            <button class="btn btn-info" data-toggle="tooltip" title="مشاهده مقاله در سایت">
                                                <i class="icon-eye"></i>
                                            </button>
                                        </a>

                                        <a href="{{route('admin.posts.show', ['post' => $post['id']])}}">
                                            <button class="btn btn-primary" data-toggle="tooltip" title="ویرایش مقاله">
                                                <i class="icon-pencil"></i>
                                            </button>
                                        </a>

                                        <button onclick="removePost({{$post['id']}})" class="btn btn-danger" data-toggle="tooltip" title="حذف مقاله">
                                            <i class="icon-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                @php
                                    $row++;
                                @endphp
                            @endforeach
                            </tbody>
                        </table>

                        {{$posts->links()}}
                    </div>
                @else
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- The Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف مقاله</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف مقاله اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>

            </div>
        </div>
    </div>
@endsection
