@extends('layouts.admin_layout')

@section('Title')
    پنل مدیریت | فرم های اسال شده
@endsection

@section('custom-css')
    <style>
        .form_name {
            padding: 15px 15px;
            text-align: center;
            margin-bottom: 30px;
            border: 2px dashed #ff6500;
            border-radius: 10px;
            background: #eee;
            font-weight: bold;
            font-size: 12pt;
        }
    </style>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1> فرم های اسال شده</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page"> فرم های اسال شده</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            @foreach($forms as $form)
                <div class="col-12 col-lg-6">
                    <div class="card">
                        <div class="body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="form_name">
                                        {{$form->first()->form->name}}
                                    </p>
                                </div>
                            </div>

                            @foreach($form as $field)
                                <div class="row">
                                    <div class="col-12">
                                        <label>
                                            {{$field->field->field_label}}
                                        </label>

                                        <textarea disabled class="form-control mb-4">{{$field->value}}</textarea>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        @if($data->total() > 1)
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            {{$data->links()}}
                        </div>
                    </div>
                </div>
            </div>
        @endif
    </div>
@endsection
