@extends('layouts.admin_layout')

@section('Title')
    پنل مدیریت | فرم ساز
@endsection

@section('custom-js')
    <script>
        function removeForm(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/formBuilder/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }
    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>فرم ساز</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">فرم ساز</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.formBuilder.create')}}" class="btn btn-sm btn-success">
                        <i class="fa fa-plus mr-2"></i>
                        افزودن فرم جدید
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                @if(!empty($forms->all()))
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8 text-center">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>نام فرم</th>
                                <th>فعال / غیر فعال</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php
                                $row = 1;
                            @endphp
                            @foreach($forms as $form)
                                <tr>
                                    <td class="w60">
                                        <span>{{$row}}</span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            {{$form['name']}}
                                        </p>
                                    </td>

                                    <td>
                                        @if($form['is_active'] == 1)
                                            <span class="badge badge-success">
                                                فعال
                                            </span>
                                        @else
                                            <span class="badge badge-danger">
                                                غیر فعال
                                            </span>

                                            <form class="d-inline-block"
                                                  action="{{route('admin.active_form', ['id' => $form['id']])}}"
                                                  method="post">
                                                @csrf
                                                <button class="btn btn-success btn-sm">
                                                    فعال شود
                                                </button>
                                            </form>
                                        @endif
                                    </td>

                                    <td>
                                        ------
                                        {{--                                        <button onclick="removeForm({{$form['id']}})" class="btn btn-danger" data-toggle="tooltip" title="حذف فرم">--}}
                                        {{--                                            <i class="icon-trash"></i>--}}
                                        {{--                                        </button>--}}
                                    </td>
                                </tr>
                                @php
                                    $row++;
                                @endphp
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>

    <!-- The Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف فرم</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف فرم اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>

            </div>
        </div>
    </div>
@endsection
