@extends('layouts.admin_layout')

@section('Title')پنل مدیریت | رویدادها - {{$event_info->name}}@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>رویدادها - {{$event_info->name}}</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">رویدادها - {{$event_info->name}}</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.event_provinces.create', ['event_id' => $event_info->id])}}" class="btn btn-sm btn-success">
                        <i class="fa fa-plus mr-2"></i>
                        افزودن رویداد استانی جدید
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                @if(!empty($events->all()))
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8 text-center">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>استان</th>
                                <th>فیلم توضیحات رویداد</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php
                                $row = (($events->currentPage() - 1) * $events->perPage() ) + 1;
                            @endphp
                            @foreach($events as $event)
                                <tr>
                                    <td class="w60">
                                        <span>{{$row}}</span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            {{$event->province->name}}
                                        </p>
                                    </td>

                                    <td>
                                        <a class="btn btn-light btn-sm" target="_blank" href="{{$event['event_description_video']}}">
                                            <i class="fa fa-eye mr-2"></i>
                                            مشاهده
                                        </a>
                                    </td>

                                    <td>
                                        <a href="{{route('admin.event_atoms.index', ['event_province_id' => $event['id']])}}">
                                            <button class="btn btn-dark" data-toggle="tooltip" title="اتم های رویداد">
                                                <i class="fa fa-user-o"></i>
                                            </button>
                                        </a>

                                        <a href="{{route('admin.event_videos.index', ['event_province_id' => $event['id']])}}">
                                            <button class="btn btn-warning" data-toggle="tooltip" title="فیلم های رویداد">
                                                <i class="fa fa-video-camera"></i>
                                            </button>
                                        </a>

                                        <a href="{{route('admin.event_pictures.index', ['event_province_id' => $event['id']])}}">
                                            <button class="btn btn-info" data-toggle="tooltip" title="تصاویر رویداد">
                                                <i class="fa fa-camera"></i>
                                            </button>
                                        </a>

                                        <a href="{{route('admin.event_provinces.edit', ['event_province' => $event['id']])}}">
                                            <button class="btn btn-primary" data-toggle="tooltip" title="ویرایش رویداد">
                                                <i class="icon-pencil"></i>
                                            </button>
                                        </a>

{{--                                        <button onclick="removePost({{$event['id']}})" class="btn btn-danger" data-toggle="tooltip" title="حذف رویداد">--}}
{{--                                            <i class="icon-trash"></i>--}}
{{--                                        </button>--}}
                                    </td>
                                </tr>
                                @php
                                    $row++;
                                @endphp
                            @endforeach
                            </tbody>
                        </table>

                        {{$events->links()}}
                    </div>
                @else
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
