@extends('layouts.admin_layout')

@section('Title')پنل مدیریت | افزودن رویداد جدید@endsection

@section('custom-css')
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/summernote/dist/summernote.css')}}"/>
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css')}}"/>

    <style>
        input::placeholder {
            color: #d5d5d5 !important;
        }
    </style>
@endsection

@section('custom-js')
    <script src="{{asset('admin/assets/vendor/summernote/dist/summernote.js')}}"></script>
    <script src="{{asset('admin/assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js')}}"></script>
    <script>
        $(".dropify").dropify();

        $('#province_select').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            maxHeight: 400,
            selectAll: true,
            nonSelectedText: 'استان را انتخاب کنید',
            filterPlaceholder: 'جستجو کنید',
            allSelectedText: 'همه انتخاب شدند',
        });
    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>افزودن رویداد استانی جدید</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item"><a href="{{route('admin.events.index')}}">رویداد ها</a></li>
                            <li class="breadcrumb-item active" aria-current="page">افزودن رویداد استانی جدید</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.event_provinces.index' , ['event_id' => $event_info->id])}}" class="btn btn-sm btn-danger">
                        <i class="fa fa-arrow-right mr-2"></i>
                        بازگشت به رویدادها
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="card">
                    <form action="{{route('admin.event_provinces.store')}}" enctype="multipart/form-data" method="post" class="body">
                        @csrf
                        <div class="row">
                            <div class="col-12 col-lg-5 col-xl-3">
                                <div class="row">
                                    <div class="col-12">
                                        <label>تصویر اصلی</label>
                                        @error('img')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <input required="required" type="file" name="img" class="dropify">
                                    </div>

                                    <div class="col-12 mt-4">
                                        <label>تصویر بالا (عنوان)</label>
                                        @error('top_img')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <input required="required" type="file" name="top_img" class="dropify">
                                    </div>

                                    <div class="col-12 mt-4">
                                        <label>استان</label>
                                        @error('province')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <div class="multiselect_div">
                                            <select required="required" id="province_select"
                                                    class="multiselect multiselect-custom form-control"
                                                    name="province">
                                                <option value="">انتخاب کنید</option>
                                                @foreach($provinces as $province)
                                                    <option value="{{$province['id']}}">
                                                        {{$province['name']}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>

                                    <div class="col-12 mt-4">
                                        <label>رویداد</label>
                                        @error('event_id')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <div class="multiselect_div">
                                            <select required="required" id="event_select"
                                                    class="multiselect multiselect-custom form-control"
                                                    name="event_id">
                                                <option value="">انتخاب کنید</option>
                                                @foreach($events as $event)
                                                    <option value="{{$event['id']}}">
                                                        {{$event['name']}}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 col-lg-7 col-xl-9">
                                <div class="row">
                                    <div class="col-12 col-xl-4 mb-4">
                                        <label>لینک تک فیلم توضیحات (ویدئو)</label>
                                        @error('description_video')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <input required="required" dir="ltr" type="text" name="description_video" class="form-control" placeholder="ex: https://test.com/video.mp4">
                                    </div>
                                    <div class="col-12 col-xl-4 mb-4">
                                        <label>لینک پوستر تک فیلم توضیحات (عکس)</label>
                                        @error('description_video_poster')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <input required="required" dir="ltr" type="text" name="description_video_poster" class="form-control" placeholder="ex: https://test.com/poster.jpg">
                                    </div>
                                    <div class="col-12 col-xl-4 mb-4">
                                        <label>عنوان توضیحات (کادر سبز)</label>
                                        @error('description_title')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <input required="required" type="text" name="description_title" class="form-control">
                                    </div>

                                    <div class="col-12 mb-4">
                                        <label>توضیحات رویداد</label>
                                        @error('description')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <textarea name="description" class="summernote">{{old('description')}}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-12 text-right">
                                <button class="btn btn-success btn-sm px-4">
                                    <i class="fa fa-plus mr-2"></i>
                                    افزودن رویداد استانی
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
