@extends('layouts.admin_layout')

@section('Title')
    پنل مدیریت | تصاویر رویداد (استان {{$event_info->province->name}} - {{$event_info->event->name}})
@endsection

@section('custom-css')
    <style>
        .w-85px {
            width: 85px;
        }
    </style>
@endsection

@section('custom-js')
    <script>
        function removePicture(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/event_pictures/delete/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }
    </script>
@endsection


@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>تصاویر رویداد (استان {{$event_info->province->name}})</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item"><a href="{{route('admin.events.index')}}">رویداد ها</a></li>
                            <li class="breadcrumb-item"><a href="{{route('admin.event_provinces.index', ['event_id' => $event_info->event_id])}}">{{$event_info->event->name}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">تصاویر رویداد
                                (استان {{$event_info->province->name}})
                            </li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.event_provinces.edit', ['event_province'=> $event_info['id']])}}"
                       class="btn btn-sm btn-warning">
                        <i class="fa fa-paperclip mr-2"></i>
                        برو به صفحه این رویداد
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="row">
                    <div class="col-12 col-lg-4 col-xl-3">
                        <div class="card">
                            <form action="{{route('admin.event_pictures.store', ['event_province_id' => $event_info['id']])}}"
                                  method="post" enctype="multipart/form-data" class="card-body">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <label>تصویر (لینک)</label>
                                        <input dir="ltr" type="text" class="form-control" name="img">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <button class="btn btn-success btn-sm w-100">
                                            <i class="fa fa-plus mr-2"></i>
                                            افزودن تصویر جدید
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="col-12 col-lg-8 col-xl-9">
                        @if(!empty($pictures->all()))
                            <div class="table-responsive">
                                <table class="table table-hover table-custom spacing8 text-center">
                                    <thead>
                                    <tr>
                                        <th><b>#</b></th>
                                        <th><b>تصویر</b></th>
                                        <th><b>عملیات</b></th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                    @php
                                        $row = 1;
                                    @endphp
                                    @foreach($pictures as $picture)
                                        <tr>
                                            <td>{{$row}}</td>
                                            <td>
                                                <a target="_blank" href="{{$picture['img']}}">
                                                    <img src="{{$picture['img']}}" class="w-85px">
                                                </a>
                                            </td>
                                            <td>
                                                <button onclick="removePicture({{$picture['id']}})" class="btn btn-danger"
                                                        data-toggle="tooltip" title="حذف تصویر از رویداد">
                                                    <i class="icon-trash"></i>
                                                </button>
                                            </td>
                                        </tr>

                                        @php
                                            $row++;
                                        @endphp
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>

                        @else
                            <div class="row">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-12">
                                                    <p class="alert alert-danger mb-0">
                                                        موردی یافت نشد.
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- The Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف تصویر از رویداد</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف تصویر از رویداد اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    @csrf
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>
            </div>
        </div>
    </div>
@endsection
