@extends('layouts.admin_layout')

@section('Title')
    پنل مدیریت | ویرایش رویداد - {{$event_info['name']}}
@endsection

@section('custom-css')
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/summernote/dist/summernote.css')}}"/>
    <link rel="stylesheet" href="{{asset('admin/assets/vendor/bootstrap-multiselect/bootstrap-multiselect.css')}}"/>

    <style>
        input::placeholder {
            color: #d5d5d5 !important;
        }
    </style>
@endsection

@section('custom-js')
    <script src="{{asset('admin/assets/vendor/summernote/dist/summernote.js')}}"></script>
    <script src="{{asset('admin/assets/vendor/bootstrap-multiselect/bootstrap-multiselect.js')}}"></script>
    <script>
        $(".dropify").dropify();

        $('#province_select').multiselect({
            enableFiltering: true,
            enableCaseInsensitiveFiltering: true,
            maxHeight: 400,
            selectAll: true,
            nonSelectedText: 'استان را انتخاب کنید',
            filterPlaceholder: 'جستجو کنید',
            allSelectedText: 'همه انتخاب شدند',
        });
    </script>
@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>افزودن رویداد جدید</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item"><a href="{{route('admin.events.index')}}">رویداد ها</a></li>
                            <li class="breadcrumb-item active" aria-current="page"> ویرایش رویداد - {{$event_info['name']}}</li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.events.index')}}" class="btn btn-sm btn-danger">
                        <i class="fa fa-arrow-right mr-2"></i>
                        بازگشت به رویدادها
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12 col-lg-6 col-xl-3">
                <div class="card">
                    <form action="{{route('admin.events.update', ['event' => $event_info['id']])}}" enctype="multipart/form-data" method="post"
                          class="body">
                        @csrf
                        @method("PUT")
                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <div class="col-12 mb-4">
                                        <label>نام رویداد</label>
                                        @error('name')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <input value="{{$event_info['name']}}" required="required" type="text" name="name" class="form-control">
                                    </div>
                                    <div class="col-12 mb-4">
                                        <label>وضعیت رویداد</label>
                                        @error('is_active')
                                        <span class="validation_label_error">{{$message}}</span>
                                        @enderror
                                        <select class="form-control" name="is_active">
                                            <option @if($event_info['is_active'] == 1) selected="selected" @endif value="1">فعال</option>
                                            <option @if($event_info['is_active'] == 0) selected="selected" @endif value="0">غیر فعال</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-2">
                            <div class="col-12 text-right">
                                <button class="btn btn-success btn-sm px-4 w-100">
                                    <i class="fa fa-edit mr-2"></i>
                                    ویرایش رویداد
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
