@extends('layouts.admin_layout')

@section('Title')
    پنل مدیریت | اتم های رویداد (استان {{$event_info->province->name}})
@endsection

@section('custom-css')
    <style>
        .w-85px {
            width: 85px;
        }

        .w-200px {
            width: 200px;
        }
    </style>
@endsection

@section('custom-js')
    <script>
        function removeAtom(id) {
            var removeModal = $("#RemoveModal");
            var action = "/panel/event_atoms/delete/" + id;
            removeModal.find('form').attr('action', action);
            removeModal.modal('show');
        }

        function editAtom(tag, id) {
            let tr = $(tag).parents('tr');

            let atom_img = tr.find('.atom_img').attr('src');
            let atom_video = tr.find('.atom_video').attr('src');
            let atom_title = tr.find('.atom_title').text();
            let atom_text = tr.find('.atom_text').text();

            var editModal = $("#editModal");
            var action = "/panel/event_atoms/update/" + id;
            editModal.find('form').attr('action', action);
            editModal.find('.atom_img').val(atom_img);
            editModal.find('.atom_video').val(atom_video);
            editModal.find('.atom_title').val(atom_title);
            editModal.find('.atom_text').val(atom_text);
            editModal.modal('show');
        }
    </script>
@endsection


@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>اتم های رویداد (استان {{$event_info->province->name}} - {{$event_info->event->name}})</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item"><a href="{{route('admin.events.index')}}">رویداد ها</a></li>
                            <li class="breadcrumb-item"><a href="{{route('admin.event_provinces.index', ['event_id' => $event_info->event_id])}}">{{$event_info->event->name}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">اتم های رویداد
                                (استان {{$event_info->province->name}})
                            </li>
                        </ol>
                    </nav>
                </div>

                <div class="col-md-6 col-sm-12 text-right hidden-xs">
                    <a href="{{route('admin.event_provinces.edit', ['event_province'=> $event_info['id']])}}"
                       class="btn btn-sm btn-warning">
                        <i class="fa fa-paperclip mr-2"></i>
                        برو به صفحه این رویداد
                    </a>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                <div class="row">
                    <div class="col-12 col-lg-4 col-xl-3">
                        <div class="card">
                            <form action="{{route('admin.event_atoms.store', ['event_province_id' => $event_info['id']])}}"
                                  method="post" enctype="multipart/form-data" class="card-body">
                                @csrf
                                <div class="row">
                                    <div class="col-12">
                                        <label>تصویر (لینک)</label>
                                        <input dir="ltr" type="text" class="form-control" name="img">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <label>ویدئو (لینک)</label>
                                        <input dir="ltr" type="text" class="form-control" name="video">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <label>عنوان</label>
                                        <input type="text" class="form-control" name="title">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <label>متن</label>
                                        <input type="text" class="form-control" name="text">
                                    </div>
                                    <div class="col-12 mt-4">
                                        <button class="btn btn-success btn-sm w-100">
                                            <i class="fa fa-plus mr-2"></i>
                                            افزودن اتم جدید
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <div class="col-12 col-lg-8 col-xl-9">
                        @if(!empty($atoms->all()))
                            <div class="table-responsive">
                                <table class="table table-hover table-custom spacing8 text-center">
                                    <thead>
                                    <tr>
                                        <th><b>#</b></th>
                                        <th><b>تصویر</b></th>
                                        <th><b>فیلم</b></th>
                                        <th><b>عنوان</b></th>
                                        <th><b>متن</b></th>
                                        <th><b>عملیات</b></th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                    @php
                                        $row = 1;
                                    @endphp
                                    @foreach($atoms as $atom)
                                        <tr>
                                            <td>{{$row}}</td>
                                            <td>
                                                <a target="_blank" href="{{$atom['img']}}">
                                                    <img src="{{$atom['img']}}" class="w-85px atom_img">
                                                </a>
                                            </td>
                                            <td>
                                                <a target="_blank" href="{{$atom['video']}}">
                                                    <video poster="{{$atom['img']}}" controls="controls"
                                                           src="{{$atom['video']}}" class="w-200px atom_video"></video>
                                                </a>
                                            </td>
                                            <td class="atom_title">{{$atom['title']}}</td>
                                            <td class="atom_text">{{$atom['text']}}</td>
                                            <td>
                                                <button onclick="editAtom(this, {{$atom['id']}})" class="btn btn-info"
                                                        data-toggle="tooltip" title="ویرایش اتم">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                                <button onclick="removeAtom({{$atom['id']}})" class="btn btn-danger"
                                                        data-toggle="tooltip" title="حذف اتم از رویداد">
                                                    <i class="icon-trash"></i>
                                                </button>
                                            </td>
                                        </tr>

                                        @php
                                            $row++;
                                        @endphp
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>

                        @else
                            <div class="row">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-12">
                                                    <p class="alert alert-danger mb-0">
                                                        موردی یافت نشد.
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- The remove Modal -->
    <div class="modal" id="RemoveModal">
        <div class="modal-dialog">
            <div class="modal-content">

                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">حذف اتم از رویداد</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <p class="alert alert-danger">
                        آیا از حذف اتم از رویداد اطمینان دارید؟
                    </p>
                </div>

                <!-- Modal footer -->
                <form action="" method="post" class="modal-footer">
                    @csrf
                    <button type="submit" class="btn btn-success">بله مطمئنم</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">خیر</button>
                </form>
            </div>
        </div>
    </div>

    <!-- The edit Modal -->
    <div class="modal" id="editModal">
        <div class="modal-dialog">
            <form action="" method="post" class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title">ویرایش اتم</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>

                <!-- Modal body -->
                <div class="modal-body">
                    <div class="row">
                        <div class="col-12">
                            <label>تصویر (لینک)</label>
                            <input dir="ltr" type="text" class="form-control atom_img" name="img">
                        </div>
                        <div class="col-12 mt-4">
                            <label>ویدئو (لینک)</label>
                            <input dir="ltr" type="text" class="form-control atom_video" name="video">
                        </div>
                        <div class="col-12 mt-4">
                            <label>عنوان</label>
                            <input type="text" class="form-control atom_title" name="title">
                        </div>
                        <div class="col-12 mt-4">
                            <label>متن</label>
                            <input type="text" class="form-control atom_text" name="text">
                        </div>
                    </div>
                </div>

                <!-- Modal footer -->
                <div class="modal-footer">
                    @csrf
                    <button type="submit" class="btn btn-success">ذخیره تغییرات</button>
                    <button type="button" class="btn btn-danger" data-dismiss="modal">انصراف</button>
                </div>
            </form>
        </div>
    </div>
@endsection
