@extends('layouts.admin_layout')

@section('Title')
    پنل مدیریت | اتم های برتر
@endsection

@section('content')
    <div class="container-fluid">
        <div class="block-header">
            <div class="row clearfix">
                <div class="col-md-6 col-sm-12">
                    <h1>اتم های برتر</h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('admin.dashboard')}}">پنل مدیریت</a></li>
                            <li class="breadcrumb-item active" aria-current="page">اتم های برتر</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>

        <div class="row clearfix">
            <div class="col-12">
                @if(!empty($events->all()))
                    <div class="table-responsive">
                        <table class="table table-hover table-custom spacing8 text-center">
                            <thead>
                            <tr>
                                <th>#</th>
                                <th>نام</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                            </thead>
                            <tbody>

                            @php
                                $row = (($events->currentPage() - 1) * $events->perPage() ) + 1;
                            @endphp
                            @foreach($events as $event)
                                <tr>
                                    <td class="w60">
                                        <span>{{$row}}</span>
                                    </td>

                                    <td>
                                        <p class="mb-0">
                                            {{$event->name}}
                                        </p>
                                    </td>

                                    <td>
                                        @if($event->is_active > 0)
                                            <span class="badge badge-success">
                                                فعال
                                            </span>
                                        @else
                                            <span class="badge badge-danger">
                                                غیر فعال
                                            </span>
                                        @endif
                                    </td>

                                    <td>
                                        <a href="{{route('admin.bestAtoms.index', ['event_id' => $event['id']])}}">
                                            <button class="btn btn-warning" data-toggle="tooltip" title="اتم های برتر">
                                                <i class="icon-users"></i>
                                            </button>
                                        </a>

                                        {{--                                        <button onclick="removePost({{$event['id']}})" class="btn btn-danger" data-toggle="tooltip" title="حذف رویداد">--}}
                                        {{--                                            <i class="icon-trash"></i>--}}
                                        {{--                                        </button>--}}
                                    </td>
                                </tr>
                                @php
                                    $row++;
                                @endphp
                            @endforeach
                            </tbody>
                        </table>

                        {{$events->links()}}
                    </div>
                @else
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <p class="alert alert-danger mb-0">
                                        موردی یافت نشد.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection
