<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('fields', function (Blueprint $table) {
            $table->unsignedBigInteger('id')->autoIncrement();
            $table->string('field_label', 255);
            $table->string('field_tag', 255);
            $table->string('field_type', 255)->nullable()->default(null);
            $table->string('field_items', 255);
            $table->string('field_name', 255);
            $table->string('level', 255);
            $table->string('required', 255)->default('yes');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fields');
    }
};
