<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('event_provinces', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('event_id');
            $table->string('event_top_img', 255);
            $table->string('event_img', 255);
            $table->string('event_description_video', 255);
            $table->string('event_description_video_poster', 255);
            $table->text('event_description');
            $table->string('event_description_title', 255);
            $table->unsignedBigInteger('province_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('event_provinces');
    }
};
