<?php

namespace App\Http\Controllers\api\v1;

use App\Http\Controllers\Controller;
use App\Models\Atom;
use App\Models\BestAtomPage;
use App\Models\BestAtomPageAtoms;
use App\Models\BestAtomPageSponsors;
use App\Models\Event;
use App\Models\EventAtoms;
use App\Models\EventPictures;
use App\Models\EventProvince;
use App\Models\EventVideos;
use App\Models\fieldValue;
use App\Models\Form;
use App\Models\Homepage;
use App\Models\Province;
use Illuminate\Http\Request;

class generalController extends Controller
{
    function getEvents()
    {
        $last_event = Event::query()->where('is_active', 1)->latest()->first();

        $events = EventProvince::query()->where('event_id', $last_event['id'])->latest()->get();

        foreach ($events as $event) {
            $event['event_img'] = asset($event['event_img']);
            $event['event_top_img'] = asset($event['event_top_img']);
            $event['province_name'] = $event->province->name;
        }

        return response()->json([
            'error' => false,
            'message' => '',
            'events' => $events,
        ]);
    }

    function getEventDetail(Request $request)
    {
        $eventInfo = EventProvince::query()->where('id', $request->event_id)->first();

        if (!$eventInfo) {
            return response()->json([
                'error' => true,
                'message' => '',
                'eventInfo' => [],
            ], 404);
        }

        $eventInfo['atoms'] = Atom::query()->where('event_province_id', $request->event_id)->get();
        $eventInfo['pictures'] = EventPictures::query()->where('event_province_id', $request->event_id)->get();
        $eventInfo['videos'] = EventVideos::query()->where('event_province_id', $request->event_id)->get();
        $eventInfo['event_top_img'] = asset($eventInfo['event_top_img']);
        $eventInfo['event_img'] = asset($eventInfo['event_img']);

        $all_events_for_this_province = EventProvince::query()
            ->where('province_id', $eventInfo['province_id'])
            ->get();

        foreach ($all_events_for_this_province as $item) {
            $item['is_active'] = $item->event->is_active;
            $item['event_name'] = $item->event->name;
        }

        return response()->json([
            'error' => false,
            'message' => '',
            'eventInfo' => $eventInfo,
            'all_events_for_this_province' => $all_events_for_this_province,
        ]);
    }

    function getBestAtoms(Request $request)
    {
        $event_id = $request->event_id;
        if ($event_id > 0) {
            $best_atom_info = BestAtomPage::query()
                ->where('event_id', $event_id)
                ->first();
        } else {
            $best_atom_info = BestAtomPage::query()
                ->whereRelation('event', 'is_active', '=', 1)
                ->latest()
                ->first();

            $event_id = $best_atom_info['event_id'];
        }

        $best_atom_info['top_img'] = asset($best_atom_info['top_img']);
        $best_atom_info['the_selected_img'] = asset($best_atom_info['the_selected_img']);

        $atoms = BestAtomPageAtoms::query()->where('event_id', $event_id)->latest()->get();
        foreach ($atoms as $atom) {
            $atom['img'] = asset($atom['img']);
        }

        $sponsors = BestAtomPageSponsors::query()->where('event_id', $event_id)->latest()->get();
        foreach ($sponsors as $sponsor) {
            $sponsor['img'] = asset($sponsor['img']);
        }

        $best_atom_info['atoms'] = $atoms;
        $best_atom_info['sponsors'] = $sponsors;

        $all_best_atoms = BestAtomPage::query()->get();

        foreach ($all_best_atoms as $item) {
            $item['is_active'] = $item->event->is_active;
            $item['event_name'] = $item->event->name;
        }

        return response()->json([
            'error' => false,
            'message' => '',
            'best_atom_info' => $best_atom_info,
            'all_best_atoms' => $all_best_atoms,
        ]);
    }

    function getHomepage()
    {
        $homepage_info = Homepage::query()->latest()->first();

        $bestAtoms = BestAtomPageAtoms::query()->latest()->get();

        foreach ($bestAtoms as $bestAtom) {
            $bestAtom['img'] = asset($bestAtom['img']);
        }

        return response()->json([
            'error' => false,
            'message' => '',
            'homepage_info' => $homepage_info,
            'bestAtoms' => $bestAtoms,
        ]);
    }

    function getIranAtomsCount()
    {
        $iran_atoms_count = EventAtoms::query()->count();

        return response()->json([
            'error' => false,
            'message' => '',
            'iran_atoms_count' => $iran_atoms_count,
        ]);
    }

    function getProvinceAtoms(Request $request)
    {
        $province_id = $request->province_id;

        $event = EventProvince::query()
            ->where('province_id', $province_id)
            ->whereRelation('event', 'is_active', '=', 1)
            ->latest()
            ->first();

        $province_info = Province::query()->where('id', $province_id)->first();
        $province_info['provinceImg'] = asset('site/assets/provinces/' . $province_info['provinceImg']);

        if (!$event) {
            return response()->json([
                'error' => false,
                'message' => '',
                'atoms' => [],
                'province_info' => $province_info,
            ]);
        }

        $event_id = $event->id;

        $province_atoms = EventAtoms::query()
            ->where('event_province_id', $event_id)
            ->latest()
            ->get();

        return response()->json([
            'error' => false,
            'message' => '',
            'atoms' => $province_atoms,
            'province_info' => $province_info,
        ]);
    }

    function getActiveForm()
    {
        $form = Form::query()
            ->where('is_active', 1)
            ->latest()
            ->first();

        $fields = $form->fields;

        foreach ($fields as $field) {
            $field['field_options'] = explode(',', $field['field_items']);
            $field['value'] = '';
        }

        return response()->json([
            'error' => false,
            'message' => '',
            'form' => $form,
            'fields' => $fields,
        ]);
    }

    function submit_event_form(Request $request)
    {
        $input = $request->all();

        $form = Form::query()
            ->where('is_active', 1)
            ->where('is_active', $input['form_id'])
            ->first();

        if (!$form) {
            return response()->json([
                'error' => false,
                'message' => 'خطایی رخ داده است لطفا صفحه را رفرش کرده و مجددا تلاش کنید',
            ]);
        }

        $fields = $form->fields;

        $unique = time() . "_" . rand(10000, 99999);

        foreach ($fields as $key => $field) {
            fieldValue::query()->create([
                'field_id' => $field['id'],
                'value' => $input['values'][$key],
                'unique_id' => $unique,
                'form_id' => $input['form_id'],
            ]);
        }

        return response()->json([
            'error' => false,
            'message' => 'اطلاعات شما با موفقیت ثبت شد',
        ]);
    }
}
