<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Homepage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class adminHomepageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $homepage_info = Homepage::query()->latest()->first();

        return view("admin.homepage.index", compact('homepage_info'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $homepage_info = Homepage::query()->latest()->firstOrFail();

        $input = $request->all();

        $validation = Validator::make($input, [
            'top_img' => 'required|string|max:255',
            'top_topic' => 'required|string|max:255',
            'top_text' => 'required|string|max:5000',
            'top_three_box_1' => 'required|string|max:255',
            'top_three_box_2' => 'required|string|max:255',
            'top_three_box_3' => 'required|string|max:255',
            'second_topic' => 'required|string|max:255',
            'second_text' => 'required|string|max:5000',
            'green_title' => 'required|string|max:255',
            'four_box_1' => 'required|string|max:255',
            'four_box_2' => 'required|string|max:255',
            'four_box_3' => 'required|string|max:255',
            'four_box_4' => 'required|string|max:255',
            'third_topic' => 'required|string|max:255',
            'third_text' => 'required|string|max:5000',
            'forth_topic' => 'required|string|max:255',
            'forth_text' => 'required|string|max:5000',
            'about_atom_video' => 'required|string|max:255',
            'about_atom_video_poster' => 'required|string|max:255',
            'about_atom_text' => 'required|string|max:5000',
        ]);

        if ($validation->fails()) {
            alert()->error('', $validation->errors()->first());
            return back()->withErrors($validation->errors())->withInput();
        }

        $homepage_info->update([
            'img' => $input['top_img'],
            'top_topic' => $input['top_topic'],
            'top_text' => $input['top_text'],
            'top_three_box_1' => $input['top_three_box_1'],
            'top_three_box_2' => $input['top_three_box_2'],
            'top_three_box_3' => $input['top_three_box_3'],
            'second_topic' => $input['second_topic'],
            'second_text' => $input['second_text'],
            'green_title' => $input['green_title'],
            'four_box_1' => $input['four_box_1'],
            'four_box_2' => $input['four_box_2'],
            'four_box_3' => $input['four_box_3'],
            'four_box_4' => $input['four_box_4'],
            'third_topic' => $input['third_topic'],
            'third_text' => $input['third_text'],
            'forth_topic' => $input['forth_topic'],
            'forth_text' => $input['forth_text'],
            'about_atom_video' => $input['about_atom_video'],
            'about_atom_video_poster' => $input['about_atom_video_poster'],
            'about_atom_text' => $input['about_atom_text'],
        ]);

        alert()->success('', 'صفحه اصلی با موفقیت ویرایش شد');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
