<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Field;
use App\Models\fieldValue;
use App\Models\Form;
use Illuminate\Http\Request;

class adminFormBuilder extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function index()
    {
        $forms = Form::query()->latest()->get();
        return view('admin.forms_builder.index', compact('forms'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function create()
    {
        $fields = Field::query()->get();
        return view('admin.forms_builder.create', compact('fields'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $input = $request->all();

        $form = Form::query()->create([
            'name' => $input['form_name']
        ]);

        $form->fields()->sync(
            $input['fields']
        );

        return response()->json([
            'error' => false,
            'message' => 'فرم با موفقیت افزوده شد',
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //$form = Form::query()->findOrFail($id);
        //Field::query()->where('form_id', $id)->delete();
        //$form->delete();
        //alert()->success('', 'فرم با موفقیت حذف شد');
        //return back();
    }

    public function active_form($id)
    {
        $form = Form::query()->findOrFail($id);

        $all_forms = Form::query()->get();

        foreach ($all_forms as $item) {
            $item->update(['is_active' => 0]);
        }

        $form->update([
            'is_active' => 1
        ]);

        alert()->success('', 'فرم با موفقیت فعال شد');
        return back();
    }

    public function sentForms()
    {
        $data = fieldValue::query()->groupBy('unique_id')->paginate(6);

        $forms = [];

        foreach ($data as $item) {
            $forms[$item['unique_id']] = fieldValue::query()
                ->where('unique_id', $item['unique_id'])
                ->get();
        }

        return view('admin.forms_builder.sent_forms', compact('forms', 'data'));
    }
}
