<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventProvince;
use App\Models\EventVideos;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class adminEventVideosController extends Controller
{
    function index($event_province_id)
    {
        $event_info = EventProvince::query()->findOrFail($event_province_id);
        $videos = EventVideos::query()->where('event_province_id', $event_province_id)->latest()->get();
        return view('admin.events.videos.index', compact('videos', 'event_province_id', 'event_info'));
    }

    function store(Request $request, $event_id)
    {
        $event_info = EventProvince::query()->findOrFail($event_id);

        $input = $request->all();
        $validation = Validator::make($input, [
            'poster' => 'required|string|max:255',
            'video' => 'required|string|max:255',
        ]);

        if ($validation->fails()) {
            alert()->error('', $validation->errors()->first());
            return back()->withErrors($validation->errors())->withInput();
        }

        EventVideos::query()->create([
            'event_province_id' => $event_id,
            'poster' => $input['poster'],
            'video' => $input['video'],
        ]);

        alert()->success('', ' ویدئو جدید برای رویداد ' . $event_info->province->name . ' با موفقیت افزوده شد ');
        return back();
    }

    function delete($atom_id)
    {
        $video_info = EventVideos::query()->findOrFail($atom_id);
        $video_info->delete();

        alert()->success('', 'ویدئو با موفقیت از رویداد حذف شد ');
        return back();
    }
}
