<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\Event;
use App\Models\EventPictures;
use App\Models\EventProvince;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class adminEventPicturesController extends Controller
{
    function index($event_province_id)
    {
        $event_info = EventProvince::query()->findOrFail($event_province_id);
        $pictures = EventPictures::query()->where('event_province_id', $event_province_id)->latest()->get();
        return view('admin.events.pictures.index', compact('pictures', 'event_province_id', 'event_info'));
    }

    function store(Request $request, $event_id)
    {
        $event_info = EventProvince::query()->findOrFail($event_id);

        $input = $request->all();
        $validation = Validator::make($input, [
            'img' => 'required|string|max:255',
        ]);

        if ($validation->fails()) {
            alert()->error('', $validation->errors()->first());
            return back()->withErrors($validation->errors())->withInput();
        }

        EventPictures::query()->create([
            'event_province_id' => $event_id,
            'img' => $input['img'],
        ]);

        alert()->success('', ' تصویر جدید برای رویداد ' . $event_info->province->name . ' با موفقیت افزوده شد ');
        return back();
    }

    function delete($atom_id)
    {
        $picture_info = EventPictures::query()->findOrFail($atom_id);
        $picture_info->delete();

        alert()->success('', 'تصویر با موفقیت از رویداد حذف شد ');
        return back();
    }
}
