<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\BestAtomPage;
use App\Models\BestAtomPageAtoms;
use App\Models\BestAtomPageSponsors;
use App\Models\Event;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class adminBestAtomPage extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Contracts\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\Contracts\View\View
     */
    public function index($event_id)
    {
        $event_info = Event::query()->where('id', $event_id)->firstOrFail();
        $best_atom_info = BestAtomPage::query()->where('event_id', $event_id)->first();
        $atoms = BestAtomPageAtoms::query()->where('event_id', $event_id)->latest()->get();
        $sponsors = BestAtomPageSponsors::query()->where('event_id', $event_id)->latest()->get();
        return view('admin.bestAtoms.index', compact('best_atom_info', 'atoms', 'sponsors', 'event_id', 'event_info'));
    }

    public function main()
    {
        $events = Event::query()->latest()->paginate(15);
        return view('admin.bestAtoms.main', compact('events'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $event_id, $id)
    {
        $best_atom_info = BestAtomPage::query()->where('id', $id)->first();

        $input = $request->all();

        $validation = Validator::make($input, [
            'top_img' => 'nullable|mimes:jpg,png,jpeg|max:2048', //2 MB
            'the_selected_img' => 'nullable|mimes:jpg,png,jpeg|max:1024',
            'target_title' => 'required|string|max:255',
            'target_description' => 'required|string|max:3000',
            'main_title' => 'required|string|max:3000',
        ]);

        if ($validation->fails()) {
            alert()->error('', $validation->errors()->first());
            return back()->withErrors($validation->errors())->withInput();
        }


        if ($id > 0) {
            $best_atom_info->update([
                'target_title' => $input['target_title'],
                'target_description' => $input['target_description'],
                'main_title' => $input['main_title'],
            ]);
        } else {
            $best_atom_info = BestAtomPage::query()->create([
                'target_title' => $input['target_title'],
                'target_description' => $input['target_description'],
                'main_title' => $input['main_title'],
                'event_id' => $event_id,
            ]);
        }

        if ($request->has('top_img')) {
            if (file_exists($best_atom_info['top_img']) and !is_dir($best_atom_info['top_img'])) {
                unlink($best_atom_info['top_img']);
            }
            $file = $request->file('top_img');
            $file_ext = $file->getClientOriginalExtension();
            $file_name = 'best_atoms_' . time() . '.' . $file_ext;
            $top_img = $file->move('site/assets/best_atoms', $file_name);

            $best_atom_info->update([
                'top_img' => $this->repair_file_src($top_img),
            ]);
        }

        if ($request->has('the_selected_img')) {
            if (file_exists($best_atom_info['the_selected_img']) and !is_dir($best_atom_info['the_selected_img'])) {
                unlink($best_atom_info['the_selected_img']);
            }
            $file = $request->file('the_selected_img');
            $file_ext = $file->getClientOriginalExtension();
            $file_name = 'selected_img_' . time() . '.' . $file_ext;
            $top_img = $file->move('site/assets/best_atoms', $file_name);

            $best_atom_info->update([
                'the_selected_img' => $this->repair_file_src($top_img),
            ]);
        }

        alert()->success('', 'صفحه اتم های برتر با موفقیت ویرایش شد');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    //addNewBestAtom
    function addNewBestAtom(Request $request, $event_id)
    {
        $input = $request->all();

        $validation = Validator::make($input, [
            'img' => 'nullable|mimes:jpg,png,jpeg|max:1024', //1 MB
            'title' => 'required|string|max:255',
            'description' => 'required|string|max:3000',
        ]);

        if ($validation->fails()) {
            alert()->error('', $validation->errors()->first());
            return back()->withErrors($validation->errors())->withInput();
        }

        $file = $request->file('img');
        $file_ext = $file->getClientOriginalExtension();
        $file_name = 'atoms_' . time() . '.' . $file_ext;
        $img = $file->move('site/assets/atoms', $file_name);

        BestAtomPageAtoms::query()->create([
            'img' => $this->repair_file_src($img),
            'title' => $input['title'],
            'description' => $input['description'],
            'event_id' => $event_id,
        ]);

        alert()->success('', 'اتم جدید با موفقیت اضافه شد');
        return back();
    }

    function deleteBestAtom(Request $request)
    {
        $id = $request->atom_id;

        $atom_info = BestAtomPageAtoms::query()->findOrFail($id);

        if (file_exists($atom_info['img']) and !is_dir($atom_info['img'])) {
            unlink($atom_info['img']);
        }

        $atom_info->delete();

        alert()->success('', 'اتم با موفقیت حذف شد');
        return back();
    }

    //Sponsors
    //addNewBestAtom
    function addNewSponsors(Request $request, $event_id)
    {
        $input = $request->all();

        $validation = Validator::make($input, [
            'img' => 'nullable|mimes:jpg,png,jpeg|max:1024', //1 MB
        ]);

        if ($validation->fails()) {
            alert()->error('', $validation->errors()->first());
            return back()->withErrors($validation->errors())->withInput();
        }

        $file = $request->file('img');
        $file_ext = $file->getClientOriginalExtension();
        $file_name = 'sponsors_' . time() . '.' . $file_ext;
        $img = $file->move('site/assets/sponsors', $file_name);

        BestAtomPageSponsors::query()->create([
            'img' => $this->repair_file_src($img),
            'event_id' => $event_id,
        ]);

        alert()->success('', 'حامی جدید با موفقیت اضافه شد');
        return back();
    }

    function bestAtomDeleteSponsors(Request $request)
    {
        $id = $request->atom_id;

        $sponsor_info = BestAtomPageSponsors::query()->findOrFail($id);

        if (file_exists($sponsor_info['img']) and !is_dir($sponsor_info['img'])) {
            unlink($sponsor_info['img']);
        }

        $sponsor_info->delete();

        alert()->success('', 'حامی با موفقیت حذف شد');
        return back();
    }

    function repair_file_src($src)
    {
        return str_replace('\\', '/', $src);
    }
}
